package editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class RoomList extends JPanel implements ActionListener {
	
	private ArrayList<RoomListItem> listItems;
	
	private JPanel addPanel;
	
	private MainEditorPanel mainPanel;
	
	public RoomList(MainEditorPanel theMainPanel) {
		
		mainPanel = theMainPanel;
		
		this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		
		listItems = new ArrayList<RoomListItem>();
		
		addPanel = new JPanel(new FlowLayout());
		JButton addButton = new JButton("Add Room...");
		addButton.addActionListener(this);
		addPanel.add(addButton);
		
		JButton setStartRoomButton = new JButton("Set starting room");
		setStartRoomButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				mainPanel.openStartRoomSelectionWizard();
			}
		});
		
		addPanel.add(setStartRoomButton);
		
		
		this.add(addPanel);
		
		thoroughlySetDimensions(new Dimension(275, 75));
	}
	
	private void thoroughlySetDimensions(Dimension d) {
		
		this.setSize(d);
		this.setPreferredSize(d);
		this.setMinimumSize(d);
		this.setMaximumSize(d);
		
	}
	

	@Override
	public void actionPerformed(ActionEvent e) {
		// placeholder
		
		
		JDialog wizardFrame = new JDialog();
		NewRoomSetupWizard wizard = new NewRoomSetupWizard(wizardFrame,
											40, 40, 38, 14, new Color(128,128,0), Color.white, new Color(128, 64, 0), 
											"",//"C:\\WFMeltdown Project\\wfMeltdown\\src\\images\\blackSky.GIF", 
											"",//"C:\\WFMeltdown Project\\wfMeltdown\\src\\images\\blue.GIF",
											"", mainPanel, null);
		wizardFrame.setContentPane(wizard);
		
		wizardFrame.setMinimumSize(new Dimension(600, 400));
		wizardFrame.setMaximumSize(new Dimension(600, 400));
		wizardFrame.setPreferredSize(new Dimension(600, 400));
		
		wizardFrame.setModal(true);
		
		wizardFrame.setVisible(true);
		
		if(wizard.wasCancelled()) {
			return;
		}
		
		
		
		RoomListItem newRoom = new RoomListItem(wizard, mainPanel);
		
		this.remove(addPanel);
		this.add(newRoom);
		this.add(addPanel);
		listItems.add(newRoom);
		
		Dimension origD = this.getPreferredSize();
		
		Dimension newD = new Dimension(origD.width, origD.height + 75);
		
		this.thoroughlySetDimensions(newD);
		
		
		RoomEditorPanel rep = newRoom.getPanel();
		
		JFrame theFrame = new JFrame();
		
		theFrame.setContentPane(rep);
		rep.setFrame(theFrame);
		theFrame.setTitle(wizard.getRoomName());
		
		theFrame.setSize(new Dimension(707, 550));
		
		theFrame.setVisible(true);
		
		
	}
	
	public RoomEditorPanel getRoomByName(String name) {
		
		for(int i = 0; i < listItems.size(); i++) {
			if(listItems.get(i).getPanel().getStaticBlockFactory().getRoomName().equals(name))
				return listItems.get(i).getPanel();
		}
		
		return null;
	}
	
	
	public ArrayList<String> getListOfRoomNames() {
		ArrayList<String> returnValue = new ArrayList<String>();
		
		for(int i = 0; i < listItems.size(); i++) {
			returnValue.add(listItems.get(i).getPanel().getStaticBlockFactory().getRoomName());
		}
		
		
		return returnValue;
	}
	
	public void setAllRoomsToNotBeStart() {
		
		for(int i = 0; i < listItems.size(); i++)
			listItems.get(i).getPanel().setStartRoom(false);
	}
	
	public void closeAllWindows() {
		
		for(int i = 0; i < listItems.size(); i++) {
			listItems.get(i).getPanel().closeWindow();
		}
		
	}
	
	
	public void removeAllRooms() {
		
		for(int i = 0; i < listItems.size(); i++) {
			this.remove(listItems.get(i));
		}
		
		listItems.clear();
		
		this.thoroughlySetDimensions(addPanel.getSize());
		
	}
	
	
	public int getRoomCount() {
		return listItems.size();
	}
	
	public RoomListItem getRoom(int index) {
		return listItems.get(index);
	}
	
	
	public String[] retrieveStartOfGameData() {
		
		for(RoomListItem i : listItems) {
			if(i.getPanel().isStartRoom()) {
				Point spawnPoint = i.getPanel().retrieveLevelStart();
				if(spawnPoint == null)
					return null;
				String returnValue[] = new String[3];
				returnValue[0] = "firstRoom:" + i.getName();
				returnValue[1] = "levelStartSpawnX:" + spawnPoint.x;
				returnValue[2] = "levelStartSpawnY:" + spawnPoint.y;
				return returnValue;
			}
		}
		
		
		
		
		return null;
		
		
	}
	
	
	
	public void addRoom(RoomListItem newRoom) {
		
		this.remove(addPanel);
		this.add(newRoom);
		this.add(addPanel);
		listItems.add(newRoom);
		
		Dimension origD = this.getPreferredSize();
		
		Dimension newD = new Dimension(origD.width, origD.height + 75);
		
		this.thoroughlySetDimensions(newD);
		
		
//		RoomEditorPanel rep = newRoom.getPanel();
//		
//		JFrame theFrame = new JFrame();
//		
//		theFrame.setContentPane(rep);
//		rep.setFrame(theFrame);
//		theFrame.setTitle(wizard.getRoomName());
//		
//		theFrame.setSize(new Dimension(707, 550));
//		
//		theFrame.setVisible(true);
		
	}
	
	
	public void updateAllIconsAndColors() {
		
		if(listItems == null)
			return;
		
		for(RoomListItem rli : listItems) {
			rli.updateIconAndColor();
		}
	}
	
	
	public RoomEditorPanel getStartRoomPanel() {
		
		if(listItems == null)
			return null;
		
		for(RoomListItem rli : listItems) {
			if(rli.getPanel() == null)
				continue;
			else if(rli.getPanel().isStartRoom())
				return rli.getPanel();
		}
		
		return null;
	}
}
